//AIM:Computation of N-Point DFT using DIT method.
//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
// We will compute the DFT of the sequence x(n)={0,1,2,3,4,5,6,7,8,9,10,11}
//using DIT(Split radix) method for N=12(4*3)
//For understanding,let us write the given data as
//x(0)=0,x(1)=1,x(2)=2,x(3)=3,x(4)=4,x(5)=5,x(6)=6,x(7)=7,x(8)=8,x(9)=9,x(10)=10,x(11)=11
x0=0;//DIT-FFT so arranging the input in shuffled order
x4=4;//DIT-FFT so arranging the input in shuffled order
x8=8;//DIT-FFT so arranging the input in shuffled order
x1=1;//DIT-FFT so arranging the input in shuffled order
x5=5;//DIT-FFT so arranging the input in shuffled order
x9=9;//DIT-FFT so arranging the input in shuffled order
x2=2;//DIT-FFT so arranging the input in shuffled order
x6=6;//DIT-FFT so arranging the input in shuffled order
x10=10;//DIT-FFT so arranging the input in shuffled order
x3=3;//DIT-FFT so arranging the input in shuffled order
x7=7;//DIT-FFT so arranging the input in shuffled order
x11=11;//DIT-FFT so arranging the input in shuffled order


//twiddle factors
W0=cos(((2*%pi)/12)*0)-sqrt(-1)*sin(((2*%pi)/12)*0)
W1=cos(((2*%pi)/12)*1)-sqrt(-1)*sin(((2*%pi)/12)*1)
W2=cos(((2*%pi)/12)*2)-sqrt(-1)*sin(((2*%pi)/12)*2)
W3=cos(((2*%pi)/12)*3)-sqrt(-1)*sin(((2*%pi)/12)*3)
W4=cos(((2*%pi)/12)*4)-sqrt(-1)*sin(((2*%pi)/12)*4)
W5=cos(((2*%pi)/12)*5)-sqrt(-1)*sin(((2*%pi)/12)*5)
W6=cos(((2*%pi)/12)*6)-sqrt(-1)*sin(((2*%pi)/12)*6)
W7=cos(((2*%pi)/12)*7)-sqrt(-1)*sin(((2*%pi)/12)*7)
W8=cos(((2*%pi)/12)*8)-sqrt(-1)*sin(((2*%pi)/12)*8)
W9=cos(((2*%pi)/12)*9)-sqrt(-1)*sin(((2*%pi)/12)*9)
W10=cos(((2*%pi)/12)*10)-sqrt(-1)*sin(((2*%pi)/12)*10)
W11=cos(((2*%pi)/12)*11)-sqrt(-1)*sin(((2*%pi)/12)*11)


//first stage
X0a=x0+x4+x8;
X1b=x0+x4*W4+x8*W8; //At line 2; x4 and x8, are to be multiplied by factor W4 and W8 respectively
X2c=x0+x4*W8+x8*W4; //At line 3; x4 and x8 are to be multiplied by factor W8 and W4 respectively
X3d=x1+x5+x9;
X4e=x1+x5*W4+x9*W8; //At line 5; x5 and x9 are to be multiplied by factor  W4 and W8 respectively 
X5f=x1+x5*W8+x9*W4; //At line 6; x5 and x9 are to be multiplied by factor W8 and W4 respectively
X6g=x2+x6+x10;
X7h=x2+x6*W4+x10*W8; // At line 8; x6 and x10 are to be multiplied by factor  W4 and W8 respectively
X8i=x2+x6*W8+x10*W4; //At line 9; x6 and x10 are to be multiplied by factor W8 and W4 respectively
X9j=x3+x7+x11;
X10k=x3+x7*W4+x11*W8; //At line 11; x7 and x11 are to be multiplied by factor W8 and W4 respectively
X11l=x3+x7*W8+x11*W4; //At line 12; x7 and x11 are to be multiplied by factor W8 and W4 respectively

//second stage
X0=X0a+X3d+X6g+X9j;
X1=X1b+X4e*W1+X7h*W2+X10k*W3;//At line 2; X4e,X7h and X10k are to be multiplied by twiddle factor W1, W2 and W3 respectively
X2=X2c+X5f*W2+X8i*W4+X11l*W6;//At line 3; X5f,X8i and X11l are to be multiplied by twiddle factor W2,W4 and W6 respectively
X3=X0a+X3d*W3+X6g*W6+X9j*W9;//At line 4; X3d,X6g and X9j are to be multiplied by twiddle factor W3, W6 and W9 respectively
X4=X1b+X4e*W4+X7h*W8+X10k*1;//At line 5; X4e,X7h and X10k are to be multiplied by twiddle factor W4, W8 and W12=1 respectively
X5=X2c+X5f*W5+X8i*W10+X11l*W3;//At line 6; X5f,X8i and X11l are to be multiplied by twiddle factor W5,W10 and W11 respectively
X6=X0a+X3d*W6+X6g*1+X9j*W6;//At line 7; X3d,X6g and X9j are to be multiplied by twiddle factor W6, W12=1 and W6 respectively
X7=X1b+X4e*W7+X7h*W2+X10k*W9;//At line 8; X4e,X7h and X10k are to be multiplied by twiddle factor W7, W2 and W9 respectively
X8=X2c+X5f*W8+X8i*W4+X11l*1;//At line 9; X5f,X8i and X11l are to be multiplied by twiddle factor W8,W4 and W11 respectively
X9=X0a+X3d*W9+X6g*W6+X9j*W3;//At line 10; X3d,X6g and X9j are to be multiplied by twiddle factor W9, W6 & W3 respectively
X10=X1b+X4e*W10+X7h*W8+X10k*W6;//At line 11; X4e,X7h and X10k are to be multiplied by twiddle factor W10, W8 & W6 respectively
X11=X2c+X5f*W11+X8i*W10+X11l*W9;//At line 12; X5f,X8i and X11l are to be multiplied by twiddle factor W11,W10 & W9 respectively

//Output
disp(X0)
disp(X1)
disp(X2)
disp(X3)
disp(X4)
disp(X5)
disp(X6)
disp(X7)
disp(X8)
disp(X9)
disp(X10)
disp(X11)
disp({X0,X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11},'So,the DFT of x(n) using Decimation-in-Time Fast Fourier Transform(DIT-FFT) is X(k)=')

//Expected output:X(k)={66,-6+22.392305i,-6+10.392305i,-6+6i,-6+3.4641016i,-6+1.6076952i,-6-4.409D-15i,
//-6-1.6076952i,-6-3.4641016i,-6-6i,-6-10.392305i,-6-22.392305i} 




